package gov.va.med.mhv.calendar.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.mhv.calendar.converter.UserCalCatConverter;
import gov.va.med.mhv.calendar.dto.UserCalCatDTO;
import gov.va.med.mhv.calendar.model.UserCalCat;
import gov.va.med.mhv.calendar.repository.UserCalCatRepository;
import gov.va.med.mhv.calendar.service.CalendarCategoryService;
import gov.va.med.mhv.calendar.service.UserCalCatService;
import gov.va.med.mhv.calendar.service.UserCalViewService;
import gov.va.med.mhv.common.api.exception.MHVException;

public class UserCalCatServiceImpl implements UserCalCatService {
	private static Logger log = LogManager.getLogger(UserCalCatServiceImpl.class);

	@Autowired
	private UserCalCatRepository userCalCatRepository;
	
	@Autowired
	private UserCalViewService userCalViewService;
	

	@Autowired
	private CalendarCategoryService calCategoryService;
	
	
	@Override
	public List<UserCalCatDTO> getUserCalCatsForUser(Long userProfileId)
			throws MHVException {
		List<UserCalCatDTO> userCalCatDtos = null;
		List<UserCalCat> userCalCats = null;

		try {
			userCalCats = userCalCatRepository.getUserCalCatsForUserProfileId(userProfileId);
		} catch (Exception e) {
			log.error("Error in fetching UserCalCatsForView " + e);
			throw new MHVException(e);			
		}

		if(userCalCats==null || userCalCats.size()==0) {
			userCalCats = new ArrayList<UserCalCat>();
		}

		userCalCatDtos = (null != userCalCats) ? new UserCalCatConverter().convert(userCalCats) : null;

		return userCalCatDtos;	
	}



		
}

